/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.PropertyException;
import jakarta.xml.bind.ValidationEventHandler;
import jakarta.xml.bind.ValidationException;
import jakarta.xml.bind.helpers.DefaultValidationEventHandler;
import org.eclipse.persistence.jaxb.JAXBErrorHandler;
import org.eclipse.persistence.oxm.XMLValidator;
import org.xml.sax.ErrorHandler;

public class JAXBValidator {
    private ValidationEventHandler validationEventHandler = new DefaultValidationEventHandler();
    private XMLValidator xmlValidator;

    public JAXBValidator(XMLValidator newValidator) {
        this.xmlValidator = newValidator;
    }

    public boolean validateRoot(Object rootObject) throws JAXBException {
        if (rootObject == null) {
            throw new IllegalArgumentException();
        }
        try {
            return this.xmlValidator.validateRoot(rootObject);
        }
        catch (Exception e) {
            throw new ValidationException((Throwable)e);
        }
    }

    public boolean validate(Object object) throws JAXBException {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        try {
            return this.xmlValidator.validate(object);
        }
        catch (Exception e) {
            throw new ValidationException((Throwable)e);
        }
    }

    public void setEventHandler(ValidationEventHandler newValidationEventHandler) throws JAXBException {
        this.validationEventHandler = null == newValidationEventHandler ? new DefaultValidationEventHandler() : newValidationEventHandler;
        this.xmlValidator.setErrorHandler((ErrorHandler)new JAXBErrorHandler(this.validationEventHandler));
    }

    public ValidationEventHandler getEventHandler() throws JAXBException {
        return this.validationEventHandler;
    }

    public void setProperty(String key, Object value) throws PropertyException {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        throw new PropertyException(key, value);
    }

    public Object getProperty(String key) throws PropertyException {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        throw new PropertyException("Unsupported Property");
    }
}

