/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.render.simplepainter;

import com.openhtmltopdf.layout.Layer;
import com.openhtmltopdf.newtable.TableCellBox;
import com.openhtmltopdf.newtable.TableSectionBox;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.DisplayListItem;
import com.openhtmltopdf.render.LineBox;
import com.openhtmltopdf.render.OperatorClip;
import com.openhtmltopdf.render.OperatorSetClip;
import com.openhtmltopdf.render.RenderingContext;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SimpleBoxCollector {
    private List<DisplayListItem> _blocks = null;
    private List<DisplayListItem> _inlines = null;
    private List<TableCellBox> _tcells = null;
    private List<DisplayListItem> _replaceds = null;
    private List<DisplayListItem> _listItems = null;
    private boolean _hasListItems = false;
    private boolean _hasReplaceds = false;

    private void addBlock(DisplayListItem block) {
        if (this._blocks == null) {
            this._blocks = new ArrayList<DisplayListItem>();
        }
        this._blocks.add(block);
    }

    private void addInline(DisplayListItem inline) {
        if (this._inlines == null) {
            this._inlines = new ArrayList<DisplayListItem>();
        }
        this._inlines.add(inline);
    }

    private void addTableCell(TableCellBox tcell) {
        if (this._tcells == null) {
            this._tcells = new ArrayList<TableCellBox>();
        }
        this._tcells.add(tcell);
    }

    private void addReplaced(DisplayListItem replaced) {
        if (this._replaceds == null) {
            this._replaceds = new ArrayList<DisplayListItem>();
        }
        this._replaceds.add(replaced);
        if (!(replaced instanceof OperatorClip) && !(replaced instanceof OperatorSetClip)) {
            this._hasReplaceds = true;
        }
    }

    private void addListItem(DisplayListItem listItem) {
        if (this._listItems == null) {
            this._listItems = new ArrayList<DisplayListItem>();
        }
        this._listItems.add(listItem);
        if (!(listItem instanceof OperatorClip) && !(listItem instanceof OperatorSetClip)) {
            this._hasListItems = true;
        }
    }

    private void clipAll(OperatorClip dli) {
        this.addBlock(dli);
        this.addInline(dli);
        this.addReplaced(dli);
        this.addListItem(dli);
    }

    private void setClipAll(OperatorSetClip dli) {
        this.addBlock(dli);
        this.addInline(dli);
        this.addReplaced(dli);
        this.addListItem(dli);
    }

    public List<DisplayListItem> blocks() {
        return this._blocks == null ? Collections.emptyList() : this._blocks;
    }

    public List<DisplayListItem> inlines() {
        return this._inlines == null ? Collections.emptyList() : this._inlines;
    }

    public List<TableCellBox> tcells() {
        return this._tcells == null ? Collections.emptyList() : this._tcells;
    }

    public List<DisplayListItem> replaceds() {
        return this._hasReplaceds ? this._replaceds : Collections.emptyList();
    }

    public List<DisplayListItem> listItems() {
        return this._hasListItems ? this._listItems : Collections.emptyList();
    }

    private boolean addBlockToLists(RenderingContext c, Layer layer, Box container, Shape ourClip) {
        this.addBlock(container);
        if (container instanceof BlockBox) {
            BlockBox block = (BlockBox)container;
            if (block.getReplacedElement() != null) {
                this.addReplaced(block);
            }
            if (block.isListItem()) {
                this.addListItem(block);
            }
        }
        if (container instanceof TableCellBox && ((TableCellBox)container).hasCollapsedPaintingBorder()) {
            this.addTableCell((TableCellBox)container);
        }
        if (ourClip != null) {
            this.clipAll(new OperatorClip(ourClip));
            return true;
        }
        return false;
    }

    public void collect(RenderingContext c, Layer layer) {
        this.collect(c, layer, layer.getMaster());
    }

    public void collect(RenderingContext c, Layer layer, Box container) {
        if (layer != container.getContainingLayer()) {
            return;
        }
        if (container instanceof LineBox) {
            this.addLineBox(c, layer, (LineBox)container);
        } else {
            Rectangle ourClip = null;
            boolean pushedClip = false;
            if (container.getLayer() == null || layer.getMaster() == container || !(container instanceof BlockBox)) {
                BlockBox block;
                if (container instanceof BlockBox && (block = (BlockBox)container).isNeedsClipOnPaint(c)) {
                    ourClip = block.getChildrenClipEdge(c);
                }
                pushedClip = this.addBlockToLists(c, layer, container, ourClip);
            }
            if (!(container instanceof TableSectionBox && (((TableSectionBox)container).isHeader() || ((TableSectionBox)container).isFooter()) && ((TableSectionBox)container).getTable().hasContentLimitContainer() && (container.getLayer() == null || container == layer.getMaster()) || container.getLayer() != null && container != layer.getMaster())) {
                for (int i = 0; i < container.getChildCount(); ++i) {
                    Box child = container.getChild(i);
                    this.collect(c, layer, child);
                }
            }
            if (pushedClip) {
                this.setClipAll(new OperatorSetClip(null));
            }
        }
    }

    private void addLineBox(RenderingContext c, Layer layer, LineBox container) {
        this.addInline(container);
        container.addAllChildren(this._inlines, layer);
    }
}

