/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.swing;

import com.openhtmltopdf.event.DocumentListener;
import com.openhtmltopdf.extend.FSStream;
import com.openhtmltopdf.extend.FSStreamFactory;
import com.openhtmltopdf.extend.FSUriResolver;
import com.openhtmltopdf.extend.UserAgentCallback;
import com.openhtmltopdf.outputdevice.helper.ExternalResourceControlPriority;
import com.openhtmltopdf.outputdevice.helper.ExternalResourceType;
import com.openhtmltopdf.resource.CSSResource;
import com.openhtmltopdf.resource.ImageResource;
import com.openhtmltopdf.resource.XMLResource;
import com.openhtmltopdf.util.LogMessageId;
import com.openhtmltopdf.util.OpenUtil;
import com.openhtmltopdf.util.XRLog;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.logging.Level;
import java.util.regex.Pattern;

public abstract class NaiveUserAgent
implements UserAgentCallback,
DocumentListener {
    protected final LinkedHashMap<String, ImageResource> _imageCache = new LinkedHashMap();
    protected final FSUriResolver DEFAULT_URI_RESOLVER = new DefaultUriResolver();
    protected final Map<ExternalResourceControlPriority, BiPredicate<String, ExternalResourceType>> _accessControllers = new EnumMap<ExternalResourceControlPriority, BiPredicate<String, ExternalResourceType>>(ExternalResourceControlPriority.class);
    protected FSUriResolver _resolver = this.DEFAULT_URI_RESOLVER;
    protected String _baseUri;
    protected Map<String, FSStreamFactory> _protocolsStreamFactory = new HashMap<String, FSStreamFactory>();

    public NaiveUserAgent() {
        DefaultHttpStreamFactory factory = new DefaultHttpStreamFactory();
        this._protocolsStreamFactory.put("http", factory);
        this._protocolsStreamFactory.put("https", factory);
        this._protocolsStreamFactory.put("data", new DataUriFactory());
        this._protocolsStreamFactory.put("classpath", new ClassPathStreamFactory());
    }

    public static byte[] getEmbeddedBase64Image(String imageDataUri) {
        int b64Index = imageDataUri.indexOf("base64,");
        if (b64Index != -1) {
            String b64encoded = imageDataUri.substring(b64Index + "base64,".length());
            return DataUriFactory.fromBase64Encoded(b64encoded);
        }
        XRLog.log(Level.SEVERE, LogMessageId.LogMessageId0Param.LOAD_EMBEDDED_DATA_URI_MUST_BE_ENCODED_IN_BASE64);
        return null;
    }

    public void setProtocolsStreamFactory(Map<String, FSStreamFactory> protocolsStreamFactory) {
        this._protocolsStreamFactory = protocolsStreamFactory;
    }

    public void setUriResolver(FSUriResolver resolver) {
        this._resolver = resolver;
    }

    public FSUriResolver getDefaultUriResolver() {
        return this.DEFAULT_URI_RESOLVER;
    }

    @Deprecated
    public void clearImageCache() {
        this._imageCache.clear();
    }

    protected FSStreamFactory getProtocolFactory(String protocol) {
        return this._protocolsStreamFactory.get(protocol);
    }

    protected boolean hasProtocolFactory(String protocol) {
        return this._protocolsStreamFactory.containsKey(protocol);
    }

    protected String extractProtocol(String uri) throws URISyntaxException {
        int idxSeparator;
        if (uri != null && (idxSeparator = uri.indexOf(58)) > 0) {
            return uri.substring(0, idxSeparator);
        }
        throw new URISyntaxException(uri, "missing protocol for URI");
    }

    protected InputStream openStream(String uri) {
        InputStream is = null;
        try {
            String protocol = this.extractProtocol(uri);
            if (this.hasProtocolFactory(protocol)) {
                return this.getProtocolFactory(protocol).getUrl(uri).getStream();
            }
            try {
                is = new URI(uri).toURL().openStream();
            }
            catch (MalformedURLException e) {
                XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.EXCEPTION_MALFORMED_URL, (Object)uri, e);
            }
            catch (FileNotFoundException e) {
                XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.EXCEPTION_ITEM_AT_URI_NOT_FOUND, (Object)uri, e);
            }
            catch (IOException e) {
                XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.EXCEPTION_IO_PROBLEM_FOR_URI, (Object)uri, e);
            }
        }
        catch (URISyntaxException e1) {
            XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.EXCEPTION_MALFORMED_URL, (Object)uri, e1);
        }
        return is;
    }

    protected Reader openReader(String uri) {
        InputStream is = null;
        try {
            String protocol = this.extractProtocol(uri);
            if (this.hasProtocolFactory(protocol)) {
                return this.getProtocolFactory(protocol).getUrl(uri).getReader();
            }
            try {
                is = new URI(uri).toURL().openStream();
            }
            catch (MalformedURLException e) {
                XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.EXCEPTION_MALFORMED_URL, (Object)uri, e);
            }
            catch (FileNotFoundException e) {
                XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.EXCEPTION_ITEM_AT_URI_NOT_FOUND, (Object)uri, e);
            }
            catch (IOException e) {
                XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.EXCEPTION_IO_PROBLEM_FOR_URI, (Object)uri, e);
            }
        }
        catch (URISyntaxException e1) {
            XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.EXCEPTION_MALFORMED_URL, (Object)uri, e1);
        }
        return is == null ? null : new InputStreamReader(is, StandardCharsets.UTF_8);
    }

    protected String readAll(Reader reader) throws IOException {
        return OpenUtil.readAll(reader);
    }

    @Override
    public CSSResource getCSSResource(String uri, ExternalResourceType type) {
        if (!this.checkAccessAllowed(uri, type, ExternalResourceControlPriority.RUN_BEFORE_RESOLVING_URI)) {
            return null;
        }
        String resolved = this._resolver.resolveURI(this._baseUri, uri);
        if (!this.checkAccessAllowed(resolved, type, ExternalResourceControlPriority.RUN_AFTER_RESOLVING_URI)) {
            return null;
        }
        if (resolved == null) {
            XRLog.log(Level.INFO, LogMessageId.LogMessageId2Param.LOAD_URI_RESOLVER_REJECTED_LOADING_AT_URI, (Object)"CSS resource", (Object)uri);
            return null;
        }
        return new CSSResource(this.openReader(resolved));
    }

    @Override
    public abstract ImageResource getImageResource(String var1, ExternalResourceType var2);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public XMLResource getXMLResource(String uri, ExternalResourceType type) {
        if (!this.checkAccessAllowed(uri, type, ExternalResourceControlPriority.RUN_BEFORE_RESOLVING_URI)) {
            return null;
        }
        String resolved = this._resolver.resolveURI(this._baseUri, uri);
        if (!this.checkAccessAllowed(resolved, type, ExternalResourceControlPriority.RUN_AFTER_RESOLVING_URI)) {
            return null;
        }
        if (resolved == null) {
            XRLog.log(Level.INFO, LogMessageId.LogMessageId2Param.LOAD_URI_RESOLVER_REJECTED_LOADING_AT_URI, (Object)"XML resource", (Object)uri);
            return null;
        }
        try (Reader inputReader = this.openReader(resolved);){
            XMLResource xMLResource = inputReader == null ? null : XMLResource.load(inputReader);
            return xMLResource;
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getBinaryResource(String uri, ExternalResourceType type) {
        if (!this.checkAccessAllowed(uri, type, ExternalResourceControlPriority.RUN_BEFORE_RESOLVING_URI)) {
            return null;
        }
        String resolved = this._resolver.resolveURI(this._baseUri, uri);
        if (!this.checkAccessAllowed(resolved, type, ExternalResourceControlPriority.RUN_AFTER_RESOLVING_URI)) {
            return null;
        }
        if (resolved == null) {
            XRLog.log(Level.INFO, LogMessageId.LogMessageId2Param.LOAD_URI_RESOLVER_REJECTED_LOADING_AT_URI, (Object)"binary resource", (Object)uri);
            return null;
        }
        try (InputStream is = this.openStream(resolved);){
            if (is == null) {
                byte[] byArray2 = null;
                return byArray2;
            }
            byte[] byArray = OpenUtil.readAll(is);
            return byArray;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public boolean isVisited(String uri) {
        return false;
    }

    public void setAccessController(ExternalResourceControlPriority prio, BiPredicate<String, ExternalResourceType> controller) {
        this._accessControllers.put(prio, controller);
    }

    public boolean checkAccessAllowed(String uriOrResolved, ExternalResourceType type, ExternalResourceControlPriority priority) {
        BiPredicate<String, ExternalResourceType> controller = this._accessControllers.get((Object)priority);
        if (uriOrResolved == null) {
            return false;
        }
        if (controller == null) {
            return true;
        }
        boolean passed = controller.test(uriOrResolved, type);
        if (!passed) {
            XRLog.log(Level.WARNING, LogMessageId.LogMessageId2Param.LOAD_RESOURCE_ACCESS_REJECTED, (Object)uriOrResolved, (Object)type);
        }
        return passed;
    }

    @Override
    public String getBaseURL() {
        return this._baseUri;
    }

    @Override
    public void setBaseURL(String uri) {
        this._baseUri = uri;
    }

    @Override
    @Deprecated
    public void documentStarted() {
        this.clearImageCache();
    }

    @Override
    @Deprecated
    public void documentLoaded() {
    }

    @Override
    @Deprecated
    public void onLayoutException(Throwable t) {
    }

    @Override
    @Deprecated
    public void onRenderException(Throwable t) {
    }

    @Override
    public String resolveURI(String uri) {
        return this._resolver.resolveURI(this.getBaseURL(), uri);
    }

    @Override
    public String resolveUri(String baseUri, String uri) {
        return this._resolver.resolveURI(baseUri, uri);
    }

    public static class DefaultUriResolver
    implements FSUriResolver {
        @Override
        public String resolveURI(String baseUri, String uri) {
            if (uri == null || uri.isEmpty()) {
                return null;
            }
            if (uri.startsWith("data:")) {
                return uri;
            }
            try {
                URI possiblyRelative = new URI(uri);
                if (possiblyRelative.isAbsolute()) {
                    return possiblyRelative.toString();
                }
                if (baseUri == null) {
                    XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.LOAD_COULD_NOT_RESOLVE_RELATIVE_URI_BECAUSE_NO_BASE_URI_WAS_PROVIDED, uri);
                    return null;
                }
                if (baseUri.startsWith("jar")) {
                    URL base = new URL(baseUri);
                    URL absolute = new URL(base, uri);
                    return absolute.toString();
                }
                URI base = new URI(baseUri);
                URI absolute = base.resolve(uri);
                return absolute.toString();
            }
            catch (URISyntaxException e) {
                XRLog.log(Level.WARNING, LogMessageId.LogMessageId3Param.EXCEPTION_URI_WITH_BASE_URI_INVALID, (Object)uri, (Object)"", (Object)baseUri, e);
                return null;
            }
            catch (MalformedURLException e) {
                XRLog.log(Level.WARNING, LogMessageId.LogMessageId3Param.EXCEPTION_URI_WITH_BASE_URI_INVALID, (Object)uri, (Object)"jar scheme", (Object)baseUri, e);
                return null;
            }
        }
    }

    public static class DefaultAccessController
    implements BiPredicate<String, ExternalResourceType> {
        @Override
        public boolean test(String uri, ExternalResourceType resourceType) {
            if (resourceType == null) {
                return false;
            }
            switch (resourceType) {
                case BINARY: 
                case CSS: 
                case FONT: 
                case IMAGE_RASTER: 
                case XML_XHTML: 
                case XML_SVG: 
                case PDF: 
                case SVG_BINARY: {
                    return true;
                }
                case FILE_EMBED: {
                    return false;
                }
            }
            return false;
        }
    }

    public static class DataUriFactory
    implements FSStreamFactory {
        static final Pattern WHITE_SPACE = Pattern.compile("\\s+");

        static byte[] fromBase64Encoded(String b64encoded) {
            return Base64.getMimeDecoder().decode(WHITE_SPACE.matcher(b64encoded).replaceAll(""));
        }

        @Override
        public FSStream getUrl(String url) {
            int idxSeparator;
            if (url != null && url.startsWith("data:") && (idxSeparator = url.indexOf(44)) > 0) {
                String data = url.substring(idxSeparator + 1);
                byte[] res = url.indexOf("base64,") == idxSeparator - 6 ? DataUriFactory.fromBase64Encoded(data) : data.getBytes(StandardCharsets.UTF_8);
                return new ByteStream(res);
            }
            return null;
        }
    }

    private static class ByteStream
    implements FSStream {
        private final byte[] input;

        ByteStream(byte[] input) {
            this.input = input;
        }

        @Override
        public InputStream getStream() {
            return new ByteArrayInputStream(this.input);
        }

        @Override
        public Reader getReader() {
            return new InputStreamReader(this.getStream(), StandardCharsets.UTF_8);
        }
    }

    public static class DefaultHttpStreamFactory
    implements FSStreamFactory {
        static final int CONNECTION_TIMEOUT = 10000;
        static final int READ_TIMEOUT = 30000;
        final int connectTimeout;
        final int readTimeout;

        public DefaultHttpStreamFactory(int connectTimeout, int readTimeout) {
            this.connectTimeout = connectTimeout;
            this.readTimeout = readTimeout;
        }

        public DefaultHttpStreamFactory() {
            this(10000, 30000);
        }

        @Override
        public FSStream getUrl(String uri) {
            InputStream is = null;
            try {
                URLConnection conn = new URI(uri).toURL().openConnection();
                conn.setConnectTimeout(this.connectTimeout);
                conn.setReadTimeout(this.readTimeout);
                conn.connect();
                is = conn.getInputStream();
            }
            catch (MalformedURLException | URISyntaxException e) {
                XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.EXCEPTION_MALFORMED_URL, (Object)uri, e);
            }
            catch (FileNotFoundException e) {
                XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.EXCEPTION_ITEM_AT_URI_NOT_FOUND, (Object)uri, e);
            }
            catch (IOException e) {
                XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.EXCEPTION_IO_PROBLEM_FOR_URI, (Object)uri, e);
            }
            return new DefaultHttpStream(is);
        }
    }

    public static class DefaultHttpStream
    implements FSStream {
        private InputStream strm;

        public DefaultHttpStream(InputStream strm) {
            this.strm = strm;
        }

        @Override
        public InputStream getStream() {
            return this.strm;
        }

        @Override
        public Reader getReader() {
            if (this.strm != null) {
                return new InputStreamReader(this.strm, StandardCharsets.UTF_8);
            }
            return null;
        }
    }

    public static class ClassPathStreamFactory
    implements FSStreamFactory {
        private final ClassLoader classLoader;

        public ClassPathStreamFactory() {
            this(null);
        }

        public ClassPathStreamFactory(ClassLoader classLoader) {
            this.classLoader = classLoader != null ? classLoader : ClassPathStreamFactory.getClassLoader();
        }

        @Override
        public FSStream getUrl(String uri) {
            InputStream is = uri != null ? this.getStream(uri) : null;
            return new ClassPathStream(is);
        }

        private String getPath(String uri) {
            URI fullUri;
            try {
                fullUri = new URI(uri);
            }
            catch (URISyntaxException e) {
                XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.EXCEPTION_MALFORMED_URL, (Object)uri, e);
                return null;
            }
            String path = fullUri.getPath();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            return path;
        }

        private InputStream getStream(String uri) {
            if (uri == null) {
                return null;
            }
            String path = this.getPath(uri);
            if (path == null) {
                return null;
            }
            InputStream is = this.classLoader != null ? this.classLoader.getResourceAsStream(path) : ClassLoader.getSystemResourceAsStream(path);
            if (is == null) {
                XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.EXCEPTION_ITEM_AT_URI_NOT_FOUND, uri);
            }
            return is;
        }

        private static ClassLoader getClassLoader() {
            ClassLoader cl = null;
            try {
                cl = Thread.currentThread().getContextClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (cl == null && (cl = ClassPathStream.class.getClassLoader()) == null) {
                try {
                    cl = ClassLoader.getSystemClassLoader();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return cl;
        }
    }

    public static class ClassPathStream
    implements FSStream {
        private final InputStream strm;

        public ClassPathStream(InputStream strm) {
            this.strm = strm;
        }

        @Override
        public InputStream getStream() {
            return this.strm;
        }

        @Override
        public Reader getReader() {
            InputStream is = this.getStream();
            if (is == null) {
                return null;
            }
            return new InputStreamReader(is, StandardCharsets.UTF_8);
        }
    }
}

