/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.event.impl;

import com.topologi.diffx.event.DiffXEvent;
import com.topologi.diffx.event.TextEvent;
import com.topologi.diffx.event.impl.DiffXEventBase;
import com.topologi.diffx.xml.XMLWriter;
import java.io.IOException;

public final class LineEvent
extends DiffXEventBase
implements TextEvent {
    private final CharSequence characters;
    private final int lineNumber;
    private final int hashCode;

    public LineEvent(CharSequence line, int lineNumber) throws NullPointerException {
        if (line == null) {
            throw new NullPointerException("The line cannot be null, use \"\"");
        }
        this.characters = line;
        this.lineNumber = lineNumber;
        this.hashCode = this.toHashCode(line);
    }

    public String toString() {
        return "line:" + this.lineNumber + ": \"" + this.getCharacters() + "\"";
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(DiffXEvent e) {
        if (e == null) {
            return false;
        }
        if (this == e) {
            return true;
        }
        if (e.getClass() != LineEvent.class) {
            return false;
        }
        LineEvent ce = (LineEvent)e;
        return ce.characters.equals(this.characters);
    }

    @Override
    public String getCharacters() {
        return this.characters.toString();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public void toXML(XMLWriter xml) throws IOException {
        xml.writeXML(this.characters.toString());
    }

    @Override
    public StringBuffer toXML(StringBuffer xml) throws NullPointerException {
        xml.append(this.characters);
        return xml;
    }

    private int toHashCode(CharSequence comment) {
        return comment != null ? 1711 + comment.hashCode() : 1711;
    }
}

