/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.format;

import com.topologi.diffx.config.DiffXConfig;
import com.topologi.diffx.config.WhiteSpaceProcessing;
import com.topologi.diffx.event.AttributeEvent;
import com.topologi.diffx.event.DiffXEvent;
import com.topologi.diffx.event.OpenElementEvent;
import com.topologi.diffx.event.impl.CharEvent;
import com.topologi.diffx.event.impl.CharactersEventBase;
import com.topologi.diffx.event.impl.SpaceEvent;
import com.topologi.diffx.format.XMLDiffXFormatter;
import com.topologi.diffx.sequence.PrefixMapping;
import com.topologi.diffx.xml.XMLWriter;
import com.topologi.diffx.xml.XMLWriterNSImpl;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;

public final class SafeXMLFormatter
implements XMLDiffXFormatter {
    private static final boolean DEBUG = false;
    private final XMLWriter xml;
    private DiffXConfig config = new DiffXConfig();
    private transient boolean writeXMLDeclaration = true;

    public SafeXMLFormatter() throws IOException {
        this(new PrintWriter(System.out));
    }

    public SafeXMLFormatter(Writer w) throws IOException {
        this.xml = new XMLWriterNSImpl(w, false);
        if (this.writeXMLDeclaration) {
            this.xml.xmlDecl();
            this.writeXMLDeclaration = false;
        }
        this.xml.setPrefixMapping("http://www.topologi.com/2005/Diff-X", "dfx");
        this.xml.setPrefixMapping("http://www.topologi.com/2005/Diff-X/Delete", "del");
        this.xml.setPrefixMapping("http://www.topologi.com/2005/Diff-X/Insert", "ins");
    }

    @Override
    public void format(DiffXEvent e) throws IOException {
        e.toXML(this.xml);
        if (e instanceof CharactersEventBase && this.config.getWhiteSpaceProcessing() == WhiteSpaceProcessing.IGNORE) {
            this.xml.writeXML(" ");
        }
        this.xml.flush();
    }

    @Override
    public void insert(DiffXEvent e) throws IOException {
        if (e instanceof OpenElementEvent) {
            e.toXML(this.xml);
            this.xml.attribute("dfx:insert", "true");
        } else if (e == SpaceEvent.NEW_LINE) {
            e.toXML(this.xml);
        } else if (e instanceof CharactersEventBase) {
            this.xml.openElement("http://www.topologi.com/2005/Diff-X", "ins", false);
            e.toXML(this.xml);
            this.xml.closeElement();
            if (this.config.getWhiteSpaceProcessing() == WhiteSpaceProcessing.IGNORE) {
                this.xml.writeXML(" ");
            }
        } else if (e instanceof AttributeEvent) {
            e.toXML(this.xml);
            this.xml.attribute("ins:" + ((AttributeEvent)e).getName(), "true");
        } else if (e instanceof CharEvent) {
            this.xml.openElement("http://www.topologi.com/2005/Diff-X", "ins", false);
            e.toXML(this.xml);
            this.xml.closeElement();
        } else {
            e.toXML(this.xml);
        }
        this.xml.flush();
    }

    @Override
    public void delete(DiffXEvent e) throws IOException {
        if (e instanceof OpenElementEvent) {
            e.toXML(this.xml);
            this.xml.attribute("dfx:delete", "true");
        } else if (e == SpaceEvent.NEW_LINE) {
            e.toXML(this.xml);
        } else if (e instanceof CharactersEventBase) {
            this.xml.openElement("http://www.topologi.com/2005/Diff-X", "del", false);
            e.toXML(this.xml);
            this.xml.closeElement();
            if (this.config.getWhiteSpaceProcessing() == WhiteSpaceProcessing.IGNORE) {
                this.xml.writeXML(" ");
            }
        } else if (e instanceof AttributeEvent) {
            this.xml.attribute("del:" + ((AttributeEvent)e).getName(), ((AttributeEvent)e).getValue());
        } else if (e instanceof CharEvent) {
            this.xml.openElement("http://www.topologi.com/2005/Diff-X", "del", false);
            e.toXML(this.xml);
            this.xml.closeElement();
        } else {
            e.toXML(this.xml);
        }
        this.xml.flush();
    }

    @Override
    public void setConfig(DiffXConfig config) {
        this.config = config;
    }

    @Override
    public void setWriteXMLDeclaration(boolean show) {
        this.writeXMLDeclaration = show;
    }

    @Override
    public void declarePrefixMapping(PrefixMapping mapping) {
        Enumeration<String> uris = mapping.getURIs();
        while (uris.hasMoreElements()) {
            String uri = uris.nextElement();
            this.xml.setPrefixMapping(uri, mapping.getPrefix(uri));
        }
    }
}

