/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.docx4j.Docx4jProperties;
import org.docx4j.fonts.FontUtils;
import org.docx4j.fonts.PhysicalFont;
import org.docx4j.fonts.fop.apps.FOPException;
import org.docx4j.fonts.fop.apps.io.InternalResourceResolver;
import org.docx4j.fonts.fop.apps.io.ResourceResolverFactory;
import org.docx4j.fonts.fop.fonts.EmbedFontInfo;
import org.docx4j.fonts.fop.fonts.FontCache;
import org.docx4j.fonts.fop.fonts.FontEventAdapter;
import org.docx4j.fonts.fop.fonts.FontTriplet;
import org.docx4j.fonts.fop.fonts.autodetect.FontFileFinder;
import org.docx4j.fonts.fop.fonts.autodetect.FontInfoFinder;
import org.docx4j.fonts.microsoft.MicrosoftFonts;
import org.docx4j.fonts.microsoft.MicrosoftFontsRegistry;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.org.apache.fop.events.DefaultEventBroadcaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhysicalFonts {
    protected static Logger log = LoggerFactory.getLogger(PhysicalFonts.class);
    protected static FontCache fontCache;
    private static final Map<String, PhysicalFont> physicalFontMap;
    private static final Map<String, PhysicalFont> physicalFontMapByFilenameLowercase;
    private static InternalResourceResolver fontResolver;
    private static FontInfoFinder fontInfoFinder;
    private static String osName;
    private static String regex;
    private static boolean loggedWarningAlready;
    private static PhysicalFont suitableFontWDings;
    private static boolean haveLookedForsuitableFontWFDings;
    private static PhysicalFont suitableFontWDings2;
    private static boolean haveLookedForsuitableFontWFDings2;
    private static PhysicalFont suitableFontSymbol;
    private static boolean haveLookedForsuitableFontSymbol;

    @Deprecated
    public static Map<String, PhysicalFont> getPhysicalFonts() {
        return physicalFontMap;
    }

    public static PhysicalFont get(String key) {
        return physicalFontMap.get(key.toLowerCase());
    }

    public static void put(String key, PhysicalFont pf) {
        if (physicalFontMap.get(key.toLowerCase()) != null) {
            log.warn("Overwriting existing physicalFontMap entry: " + key.toLowerCase());
        }
        physicalFontMap.put(key.toLowerCase(), pf);
    }

    public static String getRegex() {
        return regex;
    }

    public static void setRegex(String regex) {
        PhysicalFonts.regex = regex;
    }

    public static final void discoverPhysicalFonts() throws Exception {
        FontEventAdapter fea = new FontEventAdapter(new DefaultEventBroadcaster());
        FontFileFinder fontFileFinder = new FontFileFinder(fea);
        List<URL> fontFileList = fontFileFinder.find();
        if (regex == null) {
            Iterator<URL> iter = fontFileList.iterator();
            while (iter.hasNext()) {
                URI fontUrl = PhysicalFonts.getURI(iter.next());
                PhysicalFonts.addPhysicalFont(fontUrl);
            }
        } else {
            Pattern pattern = Pattern.compile(regex);
            Iterator<URL> iter = fontFileList.iterator();
            while (iter.hasNext()) {
                URI fontUrl = PhysicalFonts.getURI(iter.next());
                if (!pattern.matcher(fontUrl.toString()).matches()) continue;
                PhysicalFonts.addPhysicalFont(fontUrl);
            }
        }
    }

    private static URI getURI(Object o) throws Exception {
        if (o instanceof File) {
            File f = (File)o;
            return f.toURL().toURI();
        }
        if (o instanceof URL) {
            return ((URL)o).toURI();
        }
        throw new Exception("Unexpected object:" + o.getClass().getName());
    }

    public static void addPhysicalFont(URI fontUrl) {
        PhysicalFonts.addPhysicalFonts(null, fontUrl);
    }

    public static void addPhysicalFonts(String nameAsInFontTablePart, URI fontUrl) {
        List<PhysicalFont> physicalFonts = PhysicalFonts.getPhysicalFont(nameAsInFontTablePart, fontUrl);
        if (physicalFonts == null) {
            return;
        }
        PhysicalFonts.putPhysicalFonts(nameAsInFontTablePart, physicalFonts);
    }

    public static void putPhysicalFonts(String nameAsInFontTablePart, List<PhysicalFont> physicalFonts) {
        for (PhysicalFont pf : physicalFonts) {
            if (pf == null) continue;
            PhysicalFonts.put(pf.getName(), pf);
            log.debug("Added '" + pf.getName() + "' -> " + pf.getEmbeddedURI());
            if (nameAsInFontTablePart != null && PhysicalFonts.get(nameAsInFontTablePart) == null) {
                PhysicalFonts.put(nameAsInFontTablePart, pf);
                log.debug("Added '" + nameAsInFontTablePart + "' -> " + pf.getEmbeddedURI());
            }
            String filename = pf.getEmbeddedURI().toString();
            filename = filename.substring(filename.lastIndexOf("/") + 1).toLowerCase();
            if (osName.startsWith("Mac")) {
                filename = filename.replace("%20", " ");
            }
            physicalFontMapByFilenameLowercase.put(filename, pf);
            log.debug("added to filename map: " + filename);
        }
    }

    public static List<PhysicalFont> getPhysicalFont(String nameAsInFontTablePart, URI fontUrl) {
        return PhysicalFonts.getPhysicalFont(nameAsInFontTablePart, fontUrl, fontResolver);
    }

    public static List<PhysicalFont> getPhysicalFont(String nameAsInFontTablePart, URI fontUrl, InternalResourceResolver fontResolver) {
        EmbedFontInfo[] embedFontInfoList;
        ArrayList<PhysicalFont> pfList = new ArrayList<PhysicalFont>();
        if (log.isDebugEnabled()) {
            log.debug("nameAsInFontTablePart: " + nameAsInFontTablePart);
        }
        if ((embedFontInfoList = fontInfoFinder.find(fontUrl, fontResolver, fontCache)) == null) {
            if (PhysicalFonts.fontInfoFinder.log.isDebugEnabled()) {
                log.warn("Aborting: " + fontUrl.toString());
            } else {
                log.warn("Aborting: " + fontUrl.toString() + " (to investigate, set org.docx4j.fonts.fop.fonts.autodetect.FontInfoFinder to DEBUG)");
            }
            return null;
        }
        StringBuffer debug = new StringBuffer();
        for (EmbedFontInfo fontInfo : embedFontInfoList) {
            block16: {
                if (fontInfo == null) continue;
                debug.append("------- \n");
                try {
                    debug.append(fontInfo.getPostScriptName() + "\n");
                    if (!fontInfo.isEmbeddable()) {
                        log.warn(fontInfo.getEmbedURI() + " is not embeddable; ignoring this font.");
                        continue;
                    }
                }
                catch (Exception e1) {
                    if (loggedWarningAlready) break block16;
                    log.warn("Not using patched FOP; isEmbeddable() method missing.");
                    loggedWarningAlready = true;
                }
            }
            FontTriplet triplet = fontInfo.getFontTriplets().get(0);
            String lower = fontInfo.getEmbedURI().toString().toLowerCase();
            log.debug("Processing physical font: " + lower);
            debug.append(".. triplet " + triplet.getName() + " (priority " + triplet.getPriority() + "\n");
            PhysicalFont pf = null;
            if (lower.endsWith(".otf") || lower.endsWith(".ttf") || lower.endsWith(".ttc")) {
                pf = new PhysicalFont(triplet.getName(), fontInfo, fontResolver);
            } else if (lower.endsWith(".pfb")) {
                Object afm = FontUtils.pathFromURL(lower);
                afm = ((String)afm).substring(0, ((String)afm).length() - 4) + ".afm";
                log.debug("Looking for: " + (String)afm);
                File f = new File((String)afm);
                if (f.exists()) {
                    log.debug(".. found");
                    pf = new PhysicalFont(triplet.getName(), fontInfo, fontResolver);
                } else {
                    Object pfm = FontUtils.pathFromURL(lower);
                    pfm = ((String)pfm).substring(0, ((String)pfm).length() - 4) + ".pfm";
                    log.debug("Looking for: " + (String)pfm);
                    f = new File((String)pfm);
                    if (f.exists()) {
                        log.debug(".. found");
                        pf = new PhysicalFont(triplet.getName(), fontInfo, fontResolver);
                    } else {
                        log.warn("Skipping " + triplet.getName() + "; couldn't find .afm or .pfm for : " + fontInfo.getEmbedURI());
                    }
                }
            } else {
                log.warn("Skipping " + triplet.getName() + "; unsupported type: " + fontInfo.getEmbedURI());
            }
            if (pf == null) continue;
            pfList.add(pf);
        }
        log.debug(debug.toString());
        return pfList;
    }

    public static PhysicalFont getBoldForm(PhysicalFont pf) {
        String filename;
        MicrosoftFonts.Font msFont = MicrosoftFontsRegistry.getMsFonts().get(pf.getName());
        if (msFont == null) {
            log.warn("No entry in MicrosoftFontsRegistry for: " + pf.getName());
            return null;
        }
        if (msFont.getBold() == null) {
            log.debug("No bold form for: " + pf.getName());
            return null;
        }
        if (osName.startsWith("Mac")) {
            if (msFont.getBold().getMac() == null) {
                log.debug("No bold form for mac for: " + pf.getName());
                return null;
            }
            filename = msFont.getBold().getMac().toLowerCase();
        } else {
            filename = msFont.getBold().getFilename().toLowerCase();
        }
        log.debug("Fetching: " + filename);
        return physicalFontMapByFilenameLowercase.get(filename);
    }

    public static PhysicalFont getBoldItalicForm(PhysicalFont pf) {
        String filename;
        MicrosoftFonts.Font msFont = MicrosoftFontsRegistry.getMsFonts().get(pf.getName());
        if (msFont == null) {
            log.warn("No entry in MicrosoftFontsRegistry for: " + pf.getName());
            return null;
        }
        if (msFont.getBolditalic() == null) {
            log.debug("No Bolditalic form for: " + pf.getName());
            return null;
        }
        if (osName.startsWith("Mac")) {
            if (msFont.getBolditalic().getMac() == null) {
                log.debug("No Bolditalic form for mac for: " + pf.getName());
                return null;
            }
            filename = msFont.getBolditalic().getMac().toLowerCase();
        } else {
            filename = msFont.getBolditalic().getFilename().toLowerCase();
        }
        log.debug("Fetching: " + filename);
        return physicalFontMapByFilenameLowercase.get(filename);
    }

    public static PhysicalFont getItalicForm(PhysicalFont pf) {
        String filename;
        MicrosoftFonts.Font msFont = MicrosoftFontsRegistry.getMsFonts().get(pf.getName());
        if (msFont == null) {
            log.debug("No entry in MicrosoftFontsRegistry for: " + pf.getName());
            return null;
        }
        if (msFont.getItalic() == null) {
            log.info("No italic form for: " + pf.getName());
            return null;
        }
        if (osName.startsWith("Mac")) {
            if (msFont.getItalic().getMac() == null) {
                log.info("No italic form for mac for: " + pf.getName());
                return null;
            }
            filename = msFont.getItalic().getMac().toLowerCase();
        } else {
            filename = msFont.getItalic().getFilename().toLowerCase();
        }
        log.debug("Fetching: " + filename);
        return physicalFontMapByFilenameLowercase.get(filename);
    }

    public static String getPhysicalFont(OpcPackage wmlPackage, String fontName) {
        log.debug("looking for: " + fontName);
        if (!(wmlPackage instanceof WordprocessingMLPackage)) {
            log.error("Implement me for pptx4j");
            return null;
        }
        PhysicalFont pf = ((WordprocessingMLPackage)wmlPackage).getFontMapper().get(fontName);
        if (pf != null) {
            log.debug("Font '" + fontName + "' maps to " + pf.getName());
            return pf.getName();
        }
        log.warn("Font '" + fontName + "' is not mapped to a physical font. ");
        return null;
    }

    public static PhysicalFont getWDingsFont() {
        if (suitableFontWDings != null) {
            return suitableFontWDings;
        }
        if (haveLookedForsuitableFontWFDings) {
            return null;
        }
        haveLookedForsuitableFontWFDings = true;
        suitableFontWDings = PhysicalFonts.get("Noto Sans Symbols 2 Regular");
        if (suitableFontWDings != null) {
            log.info("Will use Noto Sans Symbols 2 Regular for most bullets");
            return suitableFontWDings;
        }
        suitableFontWDings = PhysicalFonts.get("Segoe UI Symbol");
        if (suitableFontWDings != null) {
            log.info("Will use Segoe UI Symbol for bullets");
            return suitableFontWDings;
        }
        return null;
    }

    public static PhysicalFont getWDingsFont2() {
        if (suitableFontWDings2 != null) {
            return suitableFontWDings2;
        }
        if (haveLookedForsuitableFontWFDings2) {
            return null;
        }
        haveLookedForsuitableFontWFDings2 = true;
        suitableFontWDings2 = PhysicalFonts.get("Noto Sans Symbols Regular");
        if (suitableFontWDings2 != null) {
            log.info("Will use Noto Sans Symbols Regular for remaining bullets");
            return suitableFontWDings2;
        }
        suitableFontWDings2 = PhysicalFonts.get("Segoe UI Symbol");
        if (suitableFontWDings2 != null) {
            log.info("Will use Segoe UI Symbol for bullets");
            return suitableFontWDings2;
        }
        return null;
    }

    public static PhysicalFont getSymbolFont() {
        if (suitableFontSymbol != null) {
            return suitableFontSymbol;
        }
        if (haveLookedForsuitableFontSymbol) {
            return null;
        }
        haveLookedForsuitableFontSymbol = true;
        suitableFontSymbol = PhysicalFonts.get("DejaVu Serif");
        if (suitableFontSymbol != null) {
            log.info("Will use DejaVu Serif for Symbol font");
            return suitableFontSymbol;
        }
        suitableFontSymbol = PhysicalFonts.get("Segoe UI Symbol");
        if (suitableFontSymbol != null) {
            log.info("Will use Segoe UI Symbol for bullets");
            return suitableFontSymbol;
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        PhysicalFonts.discoverPhysicalFonts();
        System.out.println("That should have listed your physical fonts (provided you have logging enabled).");
    }

    public static final int discoverJarFonts() throws URISyntaxException, IOException, FOPException {
        String pathPrefix = Docx4jProperties.getProperty("docx4j.fonts.PhysicalFonts.Jars.PathPrefix", "fonts");
        return PhysicalFonts.discoverJarFonts(pathPrefix);
    }

    public static final int discoverJarFonts(String pathPrefix) throws URISyntaxException, FOPException {
        List<URL> list;
        try {
            list = PhysicalFonts.getFontUrls(pathPrefix);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return 0;
        }
        for (URL u : list) {
            List<PhysicalFont> pfList;
            if (log.isDebugEnabled()) {
                log.debug(u.toString());
            }
            if ((pfList = PhysicalFonts.getPhysicalFont(null, u.toURI())) == null) continue;
            PhysicalFonts.putPhysicalFonts(null, pfList);
        }
        return list.size();
    }

    private static ClassLoader safeGetClassLoader() {
        return AccessController.doPrivileged(() -> {
            try {
                return InternalResourceResolver.class.getClassLoader();
            }
            catch (SecurityException ex) {
                log.error(ex.getLocalizedMessage(), (Throwable)ex);
                return null;
            }
        });
    }

    private static List<URL> getFontUrls(String pathPrefix) throws URISyntaxException, IOException {
        List<URL> fontUrls;
        ClassLoader cl = PhysicalFonts.safeGetClassLoader();
        if (cl == null) {
            return Collections.emptyList();
        }
        URL rootUrl = cl.getResource(pathPrefix);
        if (rootUrl == null) {
            return Collections.emptyList();
        }
        URI rootUri = rootUrl.toURI();
        if ("jar".equals(rootUri.getScheme())) {
            try (FileSystem fileSystem = FileSystems.newFileSystem(rootUri, Collections.emptyMap());){
                Path path = fileSystem.getPath(pathPrefix, new String[0]);
                fontUrls = PhysicalFonts.walkPathAndGetUrls(path);
            }
        } else {
            Path path = Paths.get(rootUri);
            fontUrls = PhysicalFonts.walkPathAndGetUrls(path);
        }
        return fontUrls;
    }

    private static List<URL> walkPathAndGetUrls(Path path) throws IOException {
        try (Stream<Path> stream = Files.walk(path, 4, new FileVisitOption[0]);){
            List<URL> list = stream.filter(p -> !Files.isDirectory(p, new LinkOption[0])).filter(p -> {
                String name = p.getFileName().toString().toLowerCase();
                return name.endsWith(".ttf") || name.endsWith(".otf");
            }).map(p -> {
                try {
                    return p.toUri().toURL();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException("Failed to convert path to URL", e);
                }
            }).collect(Collectors.toList());
            return list;
        }
    }

    static {
        try {
            osName = System.getProperty("os.name");
            fontCache = FontCache.load();
            if (fontCache == null) {
                fontCache = new FontCache();
            }
            physicalFontMap = new HashMap<String, PhysicalFont>();
            physicalFontMapByFilenameLowercase = new HashMap<String, PhysicalFont>();
            URI baseUri = new URI("/");
            fontResolver = new InternalResourceResolver(baseUri, ResourceResolverFactory.createDefaultResourceResolver());
            fontInfoFinder = new FontInfoFinder();
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
        loggedWarningAlready = false;
        haveLookedForsuitableFontWFDings = false;
        haveLookedForsuitableFontWFDings2 = false;
        haveLookedForsuitableFontSymbol = false;
    }
}

