/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts.fop.apps.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import org.apache.xmlgraphics.io.Resource;
import org.apache.xmlgraphics.io.ResourceResolver;
import org.apache.xmlgraphics.util.uri.DataURIResolver;
import org.docx4j.fonts.fop.apps.io.ResourceResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalResourceResolver {
    protected static Logger log = LoggerFactory.getLogger(InternalResourceResolver.class);
    private final URI baseUri;
    private final ResourceResolver resourceResolver;
    private final DataURIResolver dataSchemeResolver = new DataURIResolver();

    public InternalResourceResolver(URI baseUri, ResourceResolver resourceResolver) {
        this.baseUri = baseUri;
        this.resourceResolver = resourceResolver;
    }

    public InternalResourceResolver(URI baseUri) {
        this(baseUri, ResourceResolverFactory.createDefaultResourceResolver());
    }

    public URI getBaseURI() {
        return this.baseUri;
    }

    public Resource getResource(String stringUri) throws IOException, URISyntaxException {
        if (stringUri.startsWith("data:")) {
            return new Resource(this.resolveDataURI(stringUri));
        }
        return this.getResource(InternalResourceResolver.cleanURI(stringUri));
    }

    public Resource getResource(URI uri) throws IOException {
        if ("jar".equalsIgnoreCase(uri.getScheme())) {
            return this.getFromJarURI(uri);
        }
        if ("file".equalsIgnoreCase(uri.getScheme())) {
            return new Resource(Files.newInputStream(Paths.get(uri), new OpenOption[0]));
        }
        if ("data".equalsIgnoreCase(uri.getScheme())) {
            return new Resource(this.resolveDataURI(uri.toASCIIString()));
        }
        return this.resourceResolver.getResource(this.resolveFromBase(uri));
    }

    public OutputStream getOutputStream(URI uri) throws IOException {
        return this.resourceResolver.getOutputStream(this.resolveFromBase(uri));
    }

    public URI resolveFromBase(URI uri) {
        return this.baseUri.resolve(uri);
    }

    public static URI cleanURI(String uriStr) throws URISyntaxException {
        log.debug("Incoming " + uriStr);
        if (uriStr == null) {
            return null;
        }
        String fixedUri = uriStr.replace('\\', '/');
        fixedUri = fixedUri.replace(" ", "%20");
        URI baseURI = new URI(fixedUri);
        return baseURI;
    }

    public static URI getBaseURI(String base) throws URISyntaxException {
        String path = base + (base.endsWith("/") ? "" : "/");
        return InternalResourceResolver.cleanURI(path);
    }

    private InputStream resolveDataURI(String dataURI) {
        try {
            Source src = this.dataSchemeResolver.resolve(dataURI, "");
            return src == null ? null : ((StreamSource)src).getInputStream();
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    private Resource getFromJarURI(URI jarUri) throws IOException {
        URL url = jarUri.toURL();
        URLConnection conn = url.openConnection();
        if (!(conn instanceof JarURLConnection)) {
            throw new IOException("Not a JarURLConnection: " + jarUri);
        }
        JarURLConnection juc = (JarURLConnection)conn;
        InputStream in = juc.getInputStream();
        if (in == null) {
            throw new FileNotFoundException("Unable to open entry: " + jarUri);
        }
        return new Resource(in);
    }
}

