/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.jaxb;

import jakarta.xml.bind.ValidationEvent;
import jakarta.xml.bind.ValidationEventHandler;
import jakarta.xml.bind.ValidationEventLocator;
import java.io.IOException;
import java.lang.reflect.Field;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.stream.StreamSource;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.JAXBImplementation;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.PresentationMLPackage;
import org.docx4j.openpackaging.packages.SpreadsheetMLPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.org.apache.xalan.extensions.ExpressionContext;
import org.docx4j.utils.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

public class JaxbValidationEventHandler
implements ValidationEventHandler {
    private static Logger log = LoggerFactory.getLogger(JaxbValidationEventHandler.class);
    private boolean shouldContinue = false;
    public static final String UNEXPECTED_MC_ALTERNATE_CONTENT = "unexpected element (uri:\"http://schemas.openxmlformats.org/markup-compatibility/2006\", local:\"AlternateContent\")";
    static Templates mcPreprocessorXslt;
    static Templates pptxPreprocessorXslt;
    static Templates xlsxPreprocessorXslt;

    public void setContinue(boolean val) {
        this.shouldContinue = val;
    }

    public static Templates getPreprocessor(OpcPackage pkg) throws IOException, TransformerConfigurationException {
        if (pkg instanceof WordprocessingMLPackage) {
            return JaxbValidationEventHandler.getMcPreprocessor();
        }
        if (pkg instanceof PresentationMLPackage) {
            if (pptxPreprocessorXslt == null) {
                StreamSource xsltSource = new StreamSource(ResourceUtils.getResourceViaProperty("pptx4j.jaxb.JaxbValidationEventHandler.pptx", "org/pptx4j/jaxb/pptx-preprocessor.xslt"));
                pptxPreprocessorXslt = XmlUtils.getTransformerTemplate(xsltSource);
            }
            return pptxPreprocessorXslt;
        }
        if (pkg instanceof SpreadsheetMLPackage) {
            if (xlsxPreprocessorXslt == null) {
                StreamSource xsltSource = new StreamSource(ResourceUtils.getResourceViaProperty("xlsx4j.jaxb.JaxbValidationEventHandler.xlsx", "org/xlsx4j/jaxb/xlsx-preprocessor.xslt"));
                xlsxPreprocessorXslt = XmlUtils.getTransformerTemplate(xsltSource);
            }
            return xlsxPreprocessorXslt;
        }
        log.warn("Unexpected package " + pkg.getClass().getName());
        return null;
    }

    public static Templates getMcPreprocessor() throws IOException, TransformerConfigurationException {
        if (mcPreprocessorXslt == null) {
            StreamSource xsltSource = new StreamSource(ResourceUtils.getResourceViaProperty("docx4j.jaxb.JaxbValidationEventHandler", "org/docx4j/jaxb/mc-preprocessor.xslt"));
            mcPreprocessorXslt = XmlUtils.getTransformerTemplate(xsltSource);
        }
        return mcPreprocessorXslt;
    }

    public boolean handleEvent(ValidationEvent ve) {
        if (ve.getSeverity() == 2 || ve.getSeverity() == 1) {
            ValidationEventLocator locator = ve.getLocator();
            if (log.isDebugEnabled() || ve.getMessage().length() < 120) {
                log.warn(this.printSeverity(ve) + ": " + ve.getMessage());
            } else {
                log.warn(this.printSeverity(ve) + ": " + ve.getMessage().substring(0, 120));
            }
            if (ve.getLinkedException() != null && log.isDebugEnabled()) {
                ve.getLinkedException().printStackTrace();
            }
            if (locator.getColumnNumber() > -1) {
                log.warn("Column is " + locator.getColumnNumber() + " at line number " + locator.getLineNumber());
            } else if (locator.getLineNumber() > -1) {
                log.warn("Line number " + locator.getLineNumber());
            }
            if (locator.getNode() != null) {
                Node node = locator.getNode();
                log.warn("troublesome node: " + XmlUtils.w3CDomNodeToString(node));
                if (node.getParentNode() != null) {
                    log.warn("in parent node: " + XmlUtils.w3CDomNodeToString(node.getParentNode()));
                    Object path = "";
                    for (Node parent = node.getParentNode(); parent != null; parent = parent.getParentNode()) {
                        path = this.getLocalName(parent) + "/" + (String)path;
                    }
                    log.warn((String)path + this.getLocalName(node));
                }
            }
            if (locator.getOffset() > -1) {
                log.warn("At offset " + locator.getOffset());
            }
            if (locator.getObject() != null) {
                log.warn(locator.getObject().getClass().getName());
            }
        } else if (ve.getSeverity() == 0) {
            log.warn(this.printSeverity(ve) + "Message is " + ve.getMessage());
            if (ve.getMessage().startsWith("Errors limit exceeded")) {
                try {
                    log.warn("Resetting error counter to work around https://github.com/gf-metro/jaxb/issues/22");
                    Field field = null;
                    if (Context.getJaxbImplementation() == JAXBImplementation.ORACLE_JRE) {
                        field = Class.forName("com.sun.xml.internal.bind.v2.runtime.unmarshaller.UnmarshallingContext").getDeclaredField("errorsCounter");
                    } else if (Context.getJaxbImplementation() == JAXBImplementation.IBM_WEBSPHERE_XLXP) {
                        log.warn("with IBM unmarshaller");
                        field = Class.forName("com.ibm.jtc.jax.xml.bind.v2.runtime.unmarshaller.UnmarshallingContext").getDeclaredField("errorsCounter");
                    } else {
                        try {
                            field = Class.forName("com.sun.xml.bind.v2.runtime.unmarshaller.UnmarshallingContext").getDeclaredField("errorsCounter");
                        }
                        catch (Exception e) {
                            log.error("Trying to reset error counter, but not using JAXB RI:- ");
                            log.error(e.getMessage());
                        }
                    }
                    if (field == null) {
                        log.error("Unable to reset error counter. See https://github.com/plutext/docx4j/issues/164");
                    } else {
                        field.setAccessible(true);
                        field.set(null, 10);
                        log.warn(".. reset successful");
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                    log.error("Unable to reset error counter. See https://github.com/plutext/docx4j/issues/164");
                }
            }
        }
        if (this.shouldContinue) {
            log.info("continuing (with possible element/attribute loss)");
        } else if (log.isDebugEnabled()) {
            log.debug("shouldContinue is set to false", new Throwable());
        } else {
            log.info("shouldContinue is set to false");
        }
        return this.shouldContinue;
    }

    private String getLocalName(Node sourceNode) {
        if (sourceNode.getLocalName() == null) {
            return sourceNode.getNodeName();
        }
        return sourceNode.getLocalName();
    }

    public String printSeverity(ValidationEvent ve) {
        String errorLevel;
        switch (ve.getSeverity()) {
            case 2: {
                errorLevel = "(non)FATAL_ERROR";
                break;
            }
            case 1: {
                errorLevel = "ERROR";
                break;
            }
            case 0: {
                errorLevel = "WARNING";
                break;
            }
            default: {
                errorLevel = new Integer(ve.getSeverity()).toString();
            }
        }
        return "[" + errorLevel + "] ";
    }

    public static void log(ExpressionContext expressionContext, String message) {
        log.info("[String] " + message);
    }

    public static void logXml(NodeIterator nodeIterator) {
        Node n = nodeIterator.nextNode();
        log.info(XmlUtils.w3CDomNodeToString(n));
    }
}

