/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.datastorage;

import jakarta.xml.bind.util.JAXBResult;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang3.ArrayUtils;
import org.docx4j.Docx4jProperties;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.WordprocessingML.FooterPart;
import org.docx4j.openpackaging.parts.WordprocessingML.HeaderPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.utils.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class RemovalHandler {
    private static Logger log = LoggerFactory.getLogger(RemovalHandler.class);
    static Templates removalTemplate;
    private Quantifier defaultQuantifier = null;

    public RemovalHandler() {
        try {
            StreamSource xsltSource = new StreamSource(ResourceUtils.getResourceViaProperty("docx4j.model.datastorage.RemovalHandler.xslt", "org/docx4j/model/datastorage/RemovalHandler.xslt"));
            removalTemplate = XmlUtils.getTransformerTemplate(xsltSource);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error instantiating SDT removal stylesheet", e);
        }
    }

    public void removeSDTs(WordprocessingMLPackage wordMLPackage) throws Docx4JException {
        this.removeSDTs(wordMLPackage, this.getQuantifier(), (String[])null);
    }

    public void removeSDTs(WordprocessingMLPackage wordMLPackage, Quantifier quantifier, String ... keys) throws Docx4JException {
        this.removeSDTs(wordMLPackage.getMainDocumentPart(), quantifier, keys);
        RelationshipsPart rp = wordMLPackage.getMainDocumentPart().getRelationshipsPart();
        for (Relationship r : rp.getRelationships().getRelationship()) {
            if (r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/header")) {
                this.removeSDTs((HeaderPart)rp.getPart(r), quantifier, keys);
                continue;
            }
            if (!r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/footer")) continue;
            this.removeSDTs((FooterPart)rp.getPart(r), quantifier, keys);
        }
    }

    public void removeSDTs(JaxbXmlPart<? extends Object> part) throws Docx4JException {
        this.removeSDTs(part, this.getQuantifier(), (String[])null);
    }

    public void removeSDTs(JaxbXmlPart<? extends Object> part, Quantifier quantifier, String ... keys) throws Docx4JException {
        block15: {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("all", quantifier == Quantifier.ALL);
            parameters.put("all_but_placeholders", quantifier == Quantifier.ALL_BUT_PLACEHOLDERS);
            parameters.put("all_but_placeholders_content", quantifier == Quantifier.ALL_BUT_PLACEHOLDERS_CONTENT);
            if (quantifier == Quantifier.NAMED) {
                parameters.put("types", ArrayUtils.toString((Object)keys));
            }
            Source source = null;
            Object result = null;
            XMLStreamReader xmlReader = null;
            ByteArrayOutputStream baos = null;
            Document doc = null;
            if (part.isUnmarshalled() || !Docx4jProperties.getProperty("docx4j.model.datastorage.BindingHandler.Implementation", "BindingTraverserXSLT").equals("BindingTraverserStAX")) {
                log.debug(part.getPartName().getName() + " not using StAX.");
                doc = XmlUtils.marshaltoW3CDomDocument(part.getJaxbElement());
                source = new DOMSource(doc);
                result = XmlUtils.prepareJAXBResult(Context.jc);
            } else {
                log.debug(part.getPartName().getName() + " not yet unmarshalled; using StAX.");
                try {
                    xmlReader = part.getXMLStreamReader(null);
                    source = new StAXSource(xmlReader);
                    baos = new ByteArrayOutputStream();
                    result = new StreamResult(baos);
                }
                catch (Exception e) {
                    throw new Docx4JException(e.getMessage(), e);
                }
            }
            try {
                XmlUtils.transform(source, removalTemplate, parameters, (Result)result);
                if (result instanceof JAXBResult) {
                    try {
                        part.setJaxbElement(result.getResult());
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                        log.error("Input in question:" + XmlUtils.w3CDomNodeToString(doc));
                        log.error("Now trying DOMResult..");
                        result = new DOMResult();
                        XmlUtils.transform(doc, removalTemplate, parameters, (Result)result);
                        if (log.isDebugEnabled()) {
                            Document docResult = (Document)((DOMResult)result).getNode();
                            Object o = XmlUtils.unmarshal((Document)((DOMResult)result).getNode());
                            part.setJaxbElement(o);
                            break block15;
                        }
                        Object o = XmlUtils.unmarshal((Document)((DOMResult)result).getNode());
                        part.setJaxbElement(o);
                    }
                    break block15;
                }
                try {
                    xmlReader.close();
                    baos.flush();
                    if (log.isDebugEnabled()) {
                        byte[] bytes = baos.toByteArray();
                        log.debug(new String(bytes));
                        part.replacePartContent(bytes);
                    } else {
                        part.replacePartContent(baos.toByteArray());
                    }
                    baos.close();
                }
                catch (Exception e) {
                    throw new Docx4JException(e.getMessage(), e);
                }
            }
            catch (Exception e) {
                throw new Docx4JException("Error unmarshalling document part for SDT removal", e);
            }
        }
    }

    private Quantifier getQuantifier() {
        if (this.defaultQuantifier != null) {
            return this.defaultQuantifier;
        }
        String q = Docx4jProperties.getProperty("docx4j.model.datastorage.RemovalHandler.Quantifier", "ALL");
        if (q.equals("ALL")) {
            this.defaultQuantifier = Quantifier.ALL;
        } else if (q.equals("ALL_BUT_PLACEHOLDERS")) {
            this.defaultQuantifier = Quantifier.ALL_BUT_PLACEHOLDERS;
        } else if (q.equals("ALL_BUT_PLACEHOLDERS_CONTENT")) {
            this.defaultQuantifier = Quantifier.ALL_BUT_PLACEHOLDERS_CONTENT;
        } else if (q.equals("DEFAULT")) {
            this.defaultQuantifier = Quantifier.DEFAULT;
        } else if (q.equals("NAMED")) {
            this.defaultQuantifier = Quantifier.NAMED;
        } else {
            log.warn("Unknown Quantifier property value: " + q);
            this.defaultQuantifier = Quantifier.ALL;
        }
        return this.defaultQuantifier;
    }

    public static enum Quantifier {
        ALL,
        ALL_BUT_PLACEHOLDERS_CONTENT,
        ALL_BUT_PLACEHOLDERS,
        DEFAULT,
        NAMED;

    }
}

