/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.fields.seq;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.docx4j.TraversalUtil;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.model.fields.ComplexFieldLocator;
import org.docx4j.model.fields.FieldRef;
import org.docx4j.model.fields.FieldsPreprocessor;
import org.docx4j.model.fields.FldSimpleModel;
import org.docx4j.model.fields.FormattingSwitchHelper;
import org.docx4j.model.fields.SimpleFieldLocator;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.vml.CTTextbox;
import org.docx4j.wml.CTSimpleField;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldUpdaterSEQ {
    private static Logger log = LoggerFactory.getLogger(FieldUpdaterSEQ.class);
    WordprocessingMLPackage wordMLPackage;
    Map<String, Integer> counters = new HashMap<String, Integer>();
    StringBuilder report = null;
    private static final String SEQ = "SEQ";

    private int getValue(String identifier) {
        Integer i = this.counters.get(identifier);
        if (i == null) {
            this.counters.put(identifier, 1);
            return 1;
        }
        this.counters.put(identifier, i + 1);
        return i + 1;
    }

    public FieldUpdaterSEQ(WordprocessingMLPackage wordMLPackage) {
        this.wordMLPackage = wordMLPackage;
    }

    public void update() throws Docx4JException {
        this.report = new StringBuilder();
        this.updateSimple(this.wordMLPackage.getMainDocumentPart());
        this.updateComplex(this.wordMLPackage.getMainDocumentPart());
        log.info(this.report.toString());
    }

    public void updateSimple(JaxbXmlPart part) throws Docx4JException {
        FldSimpleModel fsm = new FldSimpleModel();
        List contentList = ((ContentAccessor)part).getContent();
        WordprocessingMLPackage wmlPackage = (WordprocessingMLPackage)part.getPackage();
        SimpleFieldLocator fl = new SimpleFieldLocator();
        new TraversalUtil(contentList, fl);
        this.report.append("\n\nSimple Fields in " + part.getPartName() + "\n");
        this.report.append("============= \n");
        this.report.append("Found " + fl.simpleFields.size() + " simple fields \n ");
        for (CTSimpleField simpleField : fl.simpleFields) {
            String fldSimpleName = FormattingSwitchHelper.getFldSimpleName(simpleField.getInstr());
            if (SEQ.equals(fldSimpleName)) {
                try {
                    fsm.build(simpleField.getInstr());
                }
                catch (TransformerException e) {
                    e.printStackTrace();
                }
                String key = fsm.getFldParameters().get(0);
                Object val = "" + this.getValue(key);
                val = FormattingSwitchHelper.applyFormattingSwitch(wmlPackage, fsm, (String)val);
                this.report.append(simpleField.getInstr() + "\n");
                this.report.append("--> " + (String)val + "\n");
                R r = null;
                if (simpleField.getInstr().toUpperCase().contains("MERGEFORMAT")) {
                    r = this.getFirstRun(simpleField.getContent());
                }
                if (r == null) {
                    r = Context.getWmlObjectFactory().createR();
                } else {
                    r.getContent().clear();
                }
                simpleField.getContent().clear();
                simpleField.getContent().add(r);
                Text t = Context.getWmlObjectFactory().createText();
                t.setValue((String)val);
                this.setSimpleFieldConent(r, (String)val);
                continue;
            }
            this.report.append("Ignoring " + simpleField.getInstr() + "\n");
        }
    }

    protected void setSimpleFieldConent(R r, String val) {
        Text t = Context.getWmlObjectFactory().createText();
        t.setValue(val);
        r.getContent().add(t);
    }

    private R getFirstRun(List<Object> content) {
        for (Object o : content) {
            if (!(o instanceof R)) continue;
            return (R)o;
        }
        return null;
    }

    public void updateComplex(JaxbXmlPart part) throws Docx4JException {
        FldSimpleModel fsm = new FldSimpleModel();
        List contentList = ((ContentAccessor)part).getContent();
        WordprocessingMLPackage wmlPackage = (WordprocessingMLPackage)part.getPackage();
        ComplexFieldLocator fl = new ComplexFieldLocator();
        new TraversalUtil(contentList, fl);
        this.report.append("\n Complex Fields in " + part.getPartName() + "\n");
        this.report.append("============== \n");
        this.report.append("Found " + fl.getStarts().size() + " fields \n");
        ArrayList<FieldRef> fieldRefs = new ArrayList<FieldRef>();
        for (P p : fl.getStarts()) {
            P newP;
            int index;
            if (p.getParent() instanceof ContentAccessor) {
                index = ((ContentAccessor)p.getParent()).getContent().indexOf(p);
                newP = FieldsPreprocessor.canonicalise(p, fieldRefs);
                ((ContentAccessor)p.getParent()).getContent().set(index, newP);
                continue;
            }
            if (p.getParent() instanceof List) {
                index = ((List)p.getParent()).indexOf(p);
                newP = FieldsPreprocessor.canonicalise(p, fieldRefs);
                ((List)p.getParent()).set(index, newP);
                continue;
            }
            if (p.getParent() instanceof CTTextbox) {
                index = ((CTTextbox)p.getParent()).getTxbxContent().getContent().indexOf(p);
                newP = FieldsPreprocessor.canonicalise(p, fieldRefs);
                ((CTTextbox)p.getParent()).getTxbxContent().getContent().set(index, newP);
                continue;
            }
            throw new Docx4JException("Unexpected parent: " + p.getParent().getClass().getName());
        }
        for (FieldRef fr : fieldRefs) {
            String fldName = fr.getFldName();
            if (SEQ.equals(fldName)) {
                String instr = this.extractInstr(fr.getInstructions());
                try {
                    fsm.build(instr);
                }
                catch (TransformerException e) {
                    e.printStackTrace();
                }
                Object val = null;
                String key = null;
                if (fsm.getFldParameters() != null && fsm.getFldParameters().size() > 0) {
                    key = fsm.getFldParameters().get(0);
                    if (log.isDebugEnabled()) {
                        log.debug("Key: " + key);
                        if (key.contains("\"")) {
                            log.debug("(quote char will be disregarded)");
                        }
                    }
                    key = key.replaceAll("\"", "");
                    val = "" + this.getValue(key);
                } else {
                    log.warn("FldParameters null or empty");
                }
                if (val == null) {
                    this.report.append(instr + "\n");
                    this.report.append(key + " -> NOT FOUND! \n");
                    continue;
                }
                val = FormattingSwitchHelper.applyFormattingSwitch(wmlPackage, fsm, val);
                this.report.append(instr + "\n");
                this.report.append("--> " + (String)val + "\n");
                fr.setResult((String)val);
                continue;
            }
            this.report.append("Ignoring " + fr.getFldName() + "\n");
        }
    }

    private String extractInstr(List<Object> instructions) {
        if (instructions.size() != 1) {
            log.error("TODO SEQ field contained complex instruction");
            return null;
        }
        Object o = XmlUtils.unwrap(instructions.get(0));
        if (o instanceof Text) {
            return ((Text)o).getValue();
        }
        if (log.isErrorEnabled()) {
            log.error("TODO: extract field name from " + o.getClass().getName());
            log.error(XmlUtils.marshaltoString(instructions.get(0), true, true));
        }
        return null;
    }
}

