/*
 * Decompiled with CFR 0.152.
 */
package com.documents4j.job;

import com.documents4j.job.FailedConversionFuture;
import com.documents4j.job.IConversionContext;
import com.documents4j.job.InitialConversionFuture;
import com.documents4j.job.Priority;
import com.documents4j.throwables.ConverterException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractFutureWrappingPriorityFuture<T, S extends IConversionContext>
implements RunnableFuture<Boolean>,
Comparable<Runnable> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Priority priority;
    private final Object futureExchangeLock;
    private final CountDownLatch pendingCondition;
    private volatile Future<Boolean> underlyingFuture;

    protected AbstractFutureWrappingPriorityFuture() {
        this(500);
    }

    protected AbstractFutureWrappingPriorityFuture(int priority) {
        this.priority = new Priority(priority);
        this.futureExchangeLock = new Object();
        this.pendingCondition = new CountDownLatch(1);
        this.underlyingFuture = new InitialConversionFuture();
    }

    @Override
    public int compareTo(Runnable other) {
        return this.priority.compareTo(((AbstractFutureWrappingPriorityFuture)other).getPriority());
    }

    protected Priority getPriority() {
        return this.priority;
    }

    protected CountDownLatch getPendingCondition() {
        return this.pendingCondition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Future<Boolean> conversionFuture;
        this.logger.trace("Attempt to execute conversion");
        if (this.underlyingFuture.isCancelled()) {
            return;
        }
        try {
            boolean conversionSuccessful;
            S conversionContext;
            T source = this.fetchSource();
            this.logger.trace("Source fetched: {}", source);
            try {
                Object object = this.futureExchangeLock;
                synchronized (object) {
                    block32: {
                        this.logger.trace("Run method locked wrapped future for source {}", source);
                        if (!this.underlyingFuture.isCancelled()) break block32;
                        return;
                    }
                    conversionContext = this.startConversion(source);
                    this.logger.trace("Context fetched for source {}: {}", source, conversionContext);
                    conversionFuture = conversionContext.asFuture();
                    this.underlyingFuture = conversionFuture;
                    this.logger.trace("Underlying future created for source {}: {}", source, conversionFuture);
                }
                this.logger.trace("Blocking during external conversion for source {}: {}", source, conversionFuture);
                conversionSuccessful = conversionFuture.get();
                this.logger.trace("Blocking during external conversion is over for source {}: {} (successful: {})", new Object[]{source, conversionFuture, conversionSuccessful});
            }
            finally {
                this.onSourceConsumed(source);
            }
            if (this.underlyingFuture.isCancelled()) {
                return;
            }
            if (!conversionSuccessful) {
                throw new ConverterException("Conversion failed for an unknown reason");
            }
            this.onConversionFinished(conversionContext);
        }
        catch (Exception exception) {
            Future<Boolean> initialFuture;
            RuntimeException runtimeException = AbstractFutureWrappingPriorityFuture.processException(exception);
            if (this.underlyingFuture.isCancelled()) {
                return;
            }
            conversionFuture = this.futureExchangeLock;
            synchronized (conversionFuture) {
                block35: {
                    if (!this.underlyingFuture.isCancelled()) break block35;
                    return;
                }
                this.logger.trace("Conversion caused an error", (Throwable)exception);
                initialFuture = this.underlyingFuture;
                this.underlyingFuture = new FailedConversionFuture(runtimeException);
            }
            try {
                initialFuture.cancel(true);
            }
            finally {
                try {
                    this.onConversionFailed(runtimeException);
                }
                catch (RuntimeException e) {
                    this.logger.error("Callback for failed conversion caused an exception", (Throwable)e);
                }
            }
        }
        finally {
            this.logger.trace("Release locks for {}", this.underlyingFuture);
            this.getPendingCondition().countDown();
            this.logger.trace("Locks for {} are released", this.underlyingFuture);
        }
    }

    private static RuntimeException processException(Exception e) {
        if (e instanceof ExecutionException) {
            return AbstractFutureWrappingPriorityFuture.processException((Exception)e.getCause());
        }
        if (e instanceof InterruptedException) {
            return new ConverterException("The conversion did not complete in time", (Throwable)e);
        }
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new ConverterException("The conversion failed for an unexpected reason", (Throwable)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean cancelled;
        this.logger.trace("Attempt to cancel conversion (interrupt running: {})", (Object)mayInterruptIfRunning);
        if (this.underlyingFuture.isCancelled()) {
            return false;
        }
        Object object = this.futureExchangeLock;
        synchronized (object) {
            this.logger.trace("Cancel method locked wrapped future");
            cancelled = this.underlyingFuture.cancel(mayInterruptIfRunning);
            this.logger.trace("Conversion was successfully cancelled: {}", (Object)cancelled);
        }
        if (cancelled) {
            try {
                this.onConversionCancelled();
            }
            catch (RuntimeException e) {
                this.logger.error("Callback for failed conversion caused an exception", (Throwable)e);
            }
            finally {
                this.logger.trace("Threads waiting for the conversion to finish are released");
                this.getPendingCondition().countDown();
            }
        }
        return cancelled;
    }

    protected abstract T fetchSource();

    protected abstract void onSourceConsumed(T var1);

    protected abstract S startConversion(T var1);

    protected abstract void onConversionFinished(S var1) throws Exception;

    protected abstract void onConversionCancelled();

    protected abstract void onConversionFailed(RuntimeException var1);

    @Override
    public boolean isCancelled() {
        return this.isDone() && this.underlyingFuture.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.getPendingCondition().getCount() == 0L;
    }

    @Override
    public Boolean get() throws InterruptedException, ExecutionException {
        this.getPendingCondition().await();
        return this.underlyingFuture.get();
    }

    @Override
    public Boolean get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.getPendingCondition().await(timeout, unit)) {
            return this.underlyingFuture.get();
        }
        throw new TimeoutException("Timed out while waiting for " + this.underlyingFuture);
    }
}

